using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class AuthTokenPayload
    {
        [JsonProperty("clientId")]
        public string ClientId { get; init; }

        [JsonProperty("application")]
        public ApplicationInfo Application { get; init; }

        [JsonProperty("device")]
        public DeviceInfo Device { get; init; }

        [JsonProperty("segmentation")]
        public Segmentation Segmentation { get; init; }

        [JsonProperty("sdkVersion")]
        public string SdkVersion { get; init; }

        [JsonProperty("build_number"), CanBeNull]
        public string BuildNumber { get; init; }

        [JsonProperty("adId")]
        public string AdjustId { get; init; }

        [JsonProperty("isGeoIP")]
        [CanBeNull]
        public bool? IsGeoIPEnabled { get; set; }

        [JsonProperty("is_sandbox")]
        public bool IsSandbox { get; init; }

        [JsonProperty("isBasicIntegration")]
        public bool IsBasicIntegration { get; init; }

        #region Android specific

        [JsonProperty("gps_adid")]
        [CanBeNull]
        public string GpsAdId { get; set; }

        [JsonProperty("androidId")]
        [CanBeNull]
        public string AndroidId { get; set; }

        [JsonProperty("social")]
        [CanBeNull]
        public SocialAuth Social { get; set; }

        #endregion

        #region iOS specific

        [JsonProperty("isIDFAAvailable")]
        [CanBeNull]
        public bool? IsIdfaAvailable { get; set; }

        [JsonProperty("idfa")]
        [CanBeNull]
        public string Idfa { get; set; }

        [JsonProperty("idfv")]
        [CanBeNull]
        public string Idfv { get; set; }

        #endregion

        public override string ToString()
        {
            return JsonFacade.SerializeObject(this, Formatting.Indented);
        }
    }

    internal class ApplicationInfo
    {
        [JsonProperty("name")]
        public string Name { get; set; }

        [JsonProperty("version")]
        public string Version { get; set; }
    }

    internal class DeviceInfo
    {
        [JsonProperty("name")]
        public string Name { get; set; }

        [JsonProperty("version")]
        public string Version { get; set; }
    }

    internal class Segmentation
    {
        [JsonProperty("country")]
        public string CountryCode { get; set; }

        [JsonProperty("lang")]
        public string LanguageCode { get; set; }

        [JsonProperty("launchAt")]
        public long FirstLaunchSeconds { get; set; }

        [JsonProperty("launchDate")]
        public string FirstLaunchDate { get; set; }

        [JsonProperty("newUser")]
        public bool IsNewUser { get; set; }

        [JsonProperty("orientation")]
        public string Orientation { get; set; }
    }

    internal class SocialAuth
    {
        [JsonProperty("type"), NotNull]
        public string Provider { get; set; }

        [JsonProperty("id"), NotNull]
        public string Token { get; set; }
    }
}