using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class FeatureConfig
    {
        [JsonProperty("default")]
        [CanBeNull]
        public object DefaultValue { get; set; }

        [JsonProperty("options")]
        [CanBeNull]
        public List<FeatureOption> Options { get; set; }
    }

    internal class FeatureOption
    {
        [JsonProperty("value")]
        [CanBeNull]
        public object Value { get; set; }

        [JsonProperty("trigger")]
        [CanBeNull]
        public FeatureTrigger Trigger { get; set; } = new();
    }

    internal class FeatureTrigger
    {
        [JsonProperty("subscription_status")]
        [CanBeNull]
        public CampaignSubscriptionStatus? SubscriptionStatus { get; set; }

        [JsonProperty("inapp_status")]
        [CanBeNull]
        public CampaignInAppStatus? InAppStatus { get; set; }

        [JsonProperty("social_authorization_status")]
        [CanBeNull]
        public CampaignAuthorizationStatus? AuthorizationStatus { get; set; }

        [JsonProperty("paying_status")]
        [CanBeNull]
        public CampaignPayingStatus? PayingStatus { get; set; }

        [JsonProperty("include_referrer_ids")]
        [CanBeNull]
        public List<ReferrerItem> IncludeReferrerIds { get; set; }

        [JsonProperty("exclude_referrer_ids")]
        [CanBeNull]
        public List<ReferrerItem> ExcludeReferrerIds { get; set; }

        [JsonProperty("exclude_if_all_purchased")]
        [CanBeNull]
        public List<PurchasedItem> ExcludeIfAllPurchased { get; set; }

        [JsonProperty("exclude_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> ExcludeIfAnyPurchased { get; set; }

        [JsonProperty("include_if_all_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAllPurchased { get; set; }

        [JsonProperty("include_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAnyPurchased { get; set; }
    }
}