using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class ImpressionFailEvent : IAnalyticsEvent
    {
        [JsonProperty("campaignName")]
        public string CampaignName { get; init; }

        [JsonProperty("impressionNumber")]
        public int ImpressionNumber { get; init; }

        [JsonProperty("sessionImpressionNumer")]
        public int SessionImpressionNumber { get; init; }

        [JsonProperty("campaignTypeImpressionNumber")]
        public int CampaignTypeImpressionNumber { get; init; }

        [JsonProperty("campaignTypeSessionImpressionNumber")]
        public int CampaignTypeSessionImpressionNumber { get; init; }

        [JsonProperty("eventName")]
        public string EventName { get; init; }

        [JsonProperty("eventNumber")]
        public int EventNumber { get; init; }

        [JsonProperty("sessionEventNumber")]
        public int SessionEventNumber { get; init; }

        [JsonProperty("isDefaultConfig"), CanBeNull]
        public bool? IsDefault { get; init; }

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        [JsonProperty("reason")]
        public string Reason { get; init; }

        [JsonProperty("subscriptionStatus")]
        public SubscriptionStatus SubscriptionStatus { get; init; }

        [JsonProperty("inAppStatus")]
        public InAppStatus InAppStatus { get; init; }

        [JsonProperty("parameters"), CanBeNull]
        public Dictionary<string, object> Parameters { get; init; }

        [JsonProperty("mode"), CanBeNull]
        public string Mode { get; init; }

        [JsonProperty("maxLevel")]
        public int? MaxLevel { get; init; }

        [JsonProperty("level")]
        public int? Level { get; init; }

        [JsonProperty("store_name")]
        [CanBeNull]
        public PurchaseStore? StoreName { get; set; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("sdk_version"), CanBeNull]
        public string SdkVersion { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; init; } = TimestampExtensions.UtcNowTimestamp;

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public ImpressionFailEvent()
        {
        }

        public ImpressionFailEvent(
            CampaignImpression impression,
            string reason,
            SubscriptionStatus subscription,
            InAppStatus inApp,
            LevelStateInfo levelState,
            string appVersion,
            string sdkVersion)
        {
            CampaignName = impression.CampaignName;
            ImpressionNumber = impression.ImpressionNumber!.Value;
            SessionImpressionNumber = impression.SessionImpressionNumber!.Value;
            CampaignTypeImpressionNumber = impression.CampaignTypeImpressionNumber!.Value;
            CampaignTypeSessionImpressionNumber = impression.CampaignTypeSessionImpressionNumber!.Value;
            EventName = impression.EventName;
            EventNumber = impression.EventNumber!.Value;
            SessionEventNumber = impression.SessionEventNumber!.Value;
            IsDefault = impression.IsDefaultConfig;
            Reason = reason;
            SubscriptionStatus = subscription;
            InAppStatus = inApp;
            Parameters = impression.Parameters;
            Mode = levelState.Mode;
            MaxLevel = levelState.MaxLevel;
            Level = levelState.Level;
            StoreName = impression.StoreName;
            AppVersion = appVersion;
            SdkVersion = sdkVersion;
        }
    }
}