using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class FirebaseMappingEvent : IAnalyticsEvent
    {
        [JsonProperty("app_instance_id")]
        public string AppInstanceId { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; init; } = TimestampExtensions.UtcNowTimestamp;

        [JsonProperty("sdk_version"), CanBeNull]
        public string SdkVersion { get; init; }

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public FirebaseMappingEvent()
        {
        }
    }
}