using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class AdsImpressionEvent : IAnalyticsEvent
    {
        [JsonProperty("campaignName"), NotNull]
        public string CampaignName { get; init; }

        [JsonProperty("impressionNumber")]
        public int? ImpressionNumber { get; init; }

        [JsonProperty("sessionImpressionNumber")]
        public int? SessionImpressionNumber { get; init; }

        [JsonProperty("campaignTypeImpressionNumber")]
        public int? CampaignTypeImpressionNumber { get; init; }

        [JsonProperty("campaignTypeSessionImpressionNumber")]
        public int? CampaignTypeSessionImpressionNumber { get; init; }

        [JsonProperty("eventName"), NotNull]
        public string EventName { get; init; }

        [JsonProperty("eventNumber")]
        public int? EventNumber { get; init; }

        [JsonProperty("sessionEventNumber")]
        public int? SessionEventNumber { get; init; }

        [JsonProperty("sessionNumber")]
        public int SessionNumber { get; init; }

        [JsonProperty("isDefaultConfig"), CanBeNull]
        public bool? IsDefault { get; init; }

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        [JsonProperty("adUnitId"), CanBeNull]
        public string AdUnitId { get; init; }

        [JsonProperty("networkName"), CanBeNull]
        public string NetworkName { get; init; }

        [JsonProperty("precision"), CanBeNull]
        public string Precision { get; init; }

        [JsonProperty("publisherRevenue")]
        public double? PublisherRevenue { get; init; }

        [JsonProperty("impression_id"), CanBeNull]
        public string ImpressionId { get; init; }

        [JsonProperty("subscriptionStatus")]
        public SubscriptionStatus SubscriptionStatus { get; init; }

        [JsonProperty("inAppStatus")]
        public InAppStatus InAppStatus { get; init; }

        [JsonProperty("parameters"), CanBeNull]
        public Dictionary<string, object> Parameters { get; init; }

        [JsonProperty("mode"), CanBeNull]
        public string Mode { get; init; }

        [JsonProperty("maxLevel")]
        public int? MaxLevel { get; init; }

        [JsonProperty("level")]
        public int? Level { get; init; }

        [JsonProperty("session_id"), CanBeNull]
        public string SessionId { get; init; }

        [JsonProperty("product_id"), CanBeNull]
        public string ProductId { get; init; }

        [JsonProperty("creative_id"), CanBeNull]
        public string ProductIdCreative { get; init; }

        [JsonProperty("store_name")]
        [CanBeNull]
        public PurchaseStore? StoreName { get; set; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("sdk_version"), CanBeNull]
        public string SdkVersion { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; init; } = TimestampExtensions.UtcNowTimestamp;

        // IronSource
        [JsonProperty("instanceId"), CanBeNull]
        public string InstanceId { get; init; }

        [JsonProperty("adNetwork"), CanBeNull]
        public string AdNetwork { get; init; }

        [JsonProperty("instanceName"), CanBeNull]
        public string InstanceName { get; init; }

        [JsonProperty("adUnit"), CanBeNull]
        public string AdUnit { get; init; }

        [JsonProperty("revenue")]
        public double? Revenue { get; init; }

        [JsonProperty("ab"), CanBeNull]
        public string Ab { get; init; }

        [JsonProperty("auctionId"), CanBeNull]
        public string AuctionId { get; init; }

        [JsonProperty("segmentName"), CanBeNull]
        public string SegmentName { get; init; }

        [JsonProperty("lifetimeRevenue")]
        public double? LifetimeRevenue { get; init; }

        [JsonProperty("encryptedCPM"), CanBeNull]
        public string EncryptedCpm { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public AdsImpressionEvent()
        {
        }

        public AdsImpressionEvent(
            CampaignImpression impression,
            ApplovinAdsImpression adsImpression,
            SubscriptionStatus subscription,
            InAppStatus inApp,
            LevelStateInfo levelState,
            string sessionId,
            string appVersion,
            string sdkVersion,
            bool? isBasicIntegration = null)
        {
            CampaignName = impression.CampaignName;
            ImpressionNumber = impression.ImpressionNumber;
            SessionImpressionNumber = impression.SessionImpressionNumber;
            CampaignTypeImpressionNumber = impression.CampaignTypeImpressionNumber;
            CampaignTypeSessionImpressionNumber = impression.CampaignTypeSessionImpressionNumber;
            EventNumber = impression.EventNumber;
            EventName = impression.EventName;
            SessionEventNumber = impression.SessionEventNumber;
            SessionNumber = impression.SessionNumber;
            IsDefault = impression.IsDefaultConfig;
            Parameters = impression.Parameters;

            AdUnitId = adsImpression.Id;
            NetworkName = adsImpression.Network;
            Precision = adsImpression.Precision;
            PublisherRevenue = adsImpression.Revenue;
            ImpressionId = adsImpression.ImpressionId;

            SubscriptionStatus = subscription;
            InAppStatus = inApp;

            Mode = levelState.Mode;
            MaxLevel = levelState.MaxLevel;
            Level = levelState.Level;
            SessionId = sessionId;

            ProductId = impression.ProductId;
            ProductIdCreative = impression.ProductIdCreative;

            StoreName = impression.StoreName;

            AppVersion = appVersion;
            SdkVersion = sdkVersion;

            IsBasicIntegration = isBasicIntegration;
        }

        public AdsImpressionEvent(
            CampaignImpression impression,
            IronSourceAdsImpression adsImpression,
            SubscriptionStatus subscription,
            InAppStatus inApp,
            LevelStateInfo levelState,
            string sessionId,
            string appVersion,
            string sdkVersion,
            bool? isBasicIntegration = null)
        {
            CampaignName = impression.CampaignName;
            ImpressionNumber = impression.ImpressionNumber;
            SessionImpressionNumber = impression.SessionImpressionNumber;
            CampaignTypeImpressionNumber = impression.CampaignTypeImpressionNumber;
            CampaignTypeSessionImpressionNumber = impression.CampaignTypeSessionImpressionNumber;
            EventNumber = impression.EventNumber;
            EventName = impression.EventName;
            SessionEventNumber = impression.SessionEventNumber;
            SessionNumber = impression.SessionNumber;
            IsDefault = impression.IsDefaultConfig;
            Parameters = impression.Parameters;

            InstanceId = adsImpression.Id;
            AdNetwork = adsImpression.Network;
            InstanceName = adsImpression.InstanceName;
            AdUnit = adsImpression.AdUnit;
            Revenue = adsImpression.Revenue;
            Precision = adsImpression.Precision;
            Ab = adsImpression.Ab;
            AuctionId = adsImpression.AuctionId;
            SegmentName = adsImpression.SegmentName;
            LifetimeRevenue = adsImpression.LifetimeRevenue;
            EncryptedCpm = adsImpression.EncryptedCpm;

            SubscriptionStatus = subscription;
            InAppStatus = inApp;

            Mode = levelState.Mode;
            MaxLevel = levelState.MaxLevel;
            Level = levelState.Level;
            SessionId = sessionId;

            ProductId = impression.ProductId;
            ProductIdCreative = impression.ProductIdCreative;

            StoreName = impression.StoreName;

            AppVersion = appVersion;
            SdkVersion = sdkVersion;

            IsBasicIntegration = isBasicIntegration;
        }
    }
}