using System;
using System.Collections.Generic;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    // Not included in the minimal version
    internal partial class MinimalMagifyClient : IMagifyClient
    {
        [CanBeNull]
        public IReadOnlyReactiveProperty<string> CommonClientId => new ReactiveProperty<string>(null);
        [Obsolete]
        public IAghanimApi AghanimApi { get; } = new AghanimApiStub();
        [Obsolete]
        public IReactiveProperty<AuthorizationStatus> AuthorizationStatus { get; } = new ReactiveProperty<AuthorizationStatus>();
        [Obsolete]
        public IReactiveProperty<string> ReferrerId { get; } = new ReactiveProperty<string>();
        [Obsolete]
        public LimitsModel Limits { get; } = new();
        [Obsolete]
        public IReadOnlyList<InAppProduct> InAppProducts { get; } = Array.Empty<InAppProduct>();
        [Obsolete]
        public IReadOnlyList<SubscriptionProduct> SubscriptionProducts { get; } = Array.Empty<SubscriptionProduct>();
        [Obsolete]
        public IReadOnlyReactiveProperty<IReadOnlyList<string>> Segmentations { get; } = new ReactiveProperty<IReadOnlyList<string>>();
        [Obsolete]
        public IReadOnlyReactiveProperty<IReadOnlyList<AssignedAbTest>> AssignedAbTests { get; } = new ReactiveProperty<IReadOnlyList<AssignedAbTest>>();
        [Obsolete]
        public IReactiveProperty<bool> SyncStateEnabled { get; } = new ReactiveProperty<bool>();
        [Obsolete]
        public IUniTaskSource<bool> ClientIdFromCloudLoadingPromise { get; } = new UniTaskCompletionSource<bool>();
        [Obsolete, NotNull]
        public IObservable<SyncStateResult> OnRestoreStateCompleted { get; } = new Subject<SyncStateResult>();
        [Obsolete, NotNull]
        public IReadOnlyReactiveProperty<AutoRestoreStateInfo> AutoRestoreStateInfo { get; } = new ReactiveProperty<AutoRestoreStateInfo>();
        [Obsolete, NotNull]
        public IReactiveProperty<bool> IsAutoRestoreStateEnabled { get; } = new ReactiveProperty<bool>();
        [Obsolete, NotNull]
        public bool HasSocialAuthorizationData { get; }
        [Obsolete]
        public bool SkipClientIdFromCloudLoading { get; set; }
        [Obsolete]
        public uint ClientIdFromCloudLoadingSecondsTimeout { get; set; }
        [NotNull]
        public IReadOnlyReactiveProperty<long> LastSuccessfulSyncProgressUnixTimeSeconds { get; } = new ReactiveProperty<long>();
        public bool ShouldSendLastSyncProgressTime { get; set; }

        [Obsolete]
        public event Action<LtoInfo> OnOfferAdded = delegate {};
        [Obsolete]
        public event Action<LtoInfo> OnOfferUpdated = delegate {};
        [Obsolete]
        public event Action<LtoInfo> OnOfferRemoved = delegate {};
        [Obsolete]
        public event Action<LtoInfo> OnOfferFinished = delegate {};

        [Obsolete]
        public ICampaign CampaignFor(string eventName, IReadOnlyDictionary<string, object> customParams = null, bool silent = false)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        public bool IsCampaignAvailable(string campaignName, string eventName, Dictionary<string, object> customParams = null)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        [NotNull]
        public IReadOnlyCollection<LtoInfo> GetActiveLtoOffers()
        {
            // Do nothing
            return ArraySegment<LtoInfo>.Empty;
        }

        [Obsolete]
        public void CompleteOffer(string campaignName)
        {
            // Do nothing
        }

        [Obsolete]
        public CampaignImpression GetCampaignImpression(string campaignName)
        {
            // Do nothing
            return default;
        }

        public bool HasProcessedPurchase(string productId)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        public bool SubscribeCampaignUpdates(ICampaign campaign, Action onUpdate)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        public void UnsubscribeCampaignUpdates(string campaignName, Action onUpdate)
        {
            // Do nothing
        }

        [Obsolete]
        public void ClearSubscriptions(string campaignName)
        {
            // Do nothing
        }

        [Obsolete]
        public void SetGameLevel(int level)
        {
            // Do nothing
        }

        [Obsolete]
        public void SetGameMaxLevel(int maxLevel)
        {
            // Do nothing
        }

        [Obsolete]
        public void SetGameMode([CanBeNull] string mode)
        {
            // Do nothing
        }

        [Obsolete]
        public void SetUserEmail(string email)
        {
            // Do nothing
        }

        [Obsolete]
        public UniTask<bool> RequestSocialAuthTokenFor(string provider, [NotNull] string token, CancellationToken cancellationToken)
        {
            // Do nothing
            return default;
        }

        public void ResetSocialAuthToken()
        {
            // Do nothing
        }

        [Obsolete]
        public UniTask<SyncStateResult> SaveState(int? weight, CancellationToken cancellationToken)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        public UniTask<SyncStateResult> RestoreState(int? weight, CancellationToken cancellationToken)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        public void SetupConversionTracker(string revenuePerCountryPath, string revenueLevelsPath, string defaultCurrencyRatesPath, string subscriptionMultipliersPath)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackCustomEvent(string eventName, Dictionary<string, object> customParams = null)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackImpression(string campaignName)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackParentCampaignImpression(string campaignName)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackProductsImpression(string campaignName, IReadOnlyList<string> productIds)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackImpressionFailFor(string campaignName, string reason)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackClickFor(string campaignName)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackProductClickFor(string campaignName, string productId, PurchaseStore? store)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackAdsClickFor(string campaignName)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackAdsProductClickFor(string campaignName, string productId)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackSubscriptionActivation(bool isTrial, string productId, string price, string currency, string transactionId, string purchaseToken, string originalTransactionId, string receipt, bool needValidation, PurchaseStore store)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackInAppFor(string productId, string price, string currency, string transactionId, string purchaseToken, string originalTransactionId, string receipt, bool needValidation, PurchaseStore store)
        {
            // Do nothing
        }

        public void TrackTrustedInAppFor(TrustedPurchaseRecord record)
        {
            // Do nothing
        }

        public void TrackTrustedSubscriptionActivation(TrustedPurchaseRecord record)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackRestoredInAppFor(string productId)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackRestoredSubscription(string productId)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackRewardGranted(string productId)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackFreeBonusGranted(string productId)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackOrdinaryProductUsed(string productId)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackIncomeTransaction(string source, List<BonusInfo> bonuses, ProductInfo product = null)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackExpenseTransaction(List<BonusInfo> bonuses)
        {
            // Do nothing
        }

        [Obsolete]
        public void TrackCorrectionTransaction(List<BonusInfo> bonuses)
        {
            // Do nothing
        }

        [Obsolete]
        public CampaignRequest GetLastCampaignRequest(string campaignName)
        {
            // Do nothing
            return default;
        }

        [Obsolete]
        public CampaignRequest GetLastCampaignRequest(CampaignType campaignType)
        {
            // Do nothing
            return default;
        }
    }
}