using System.Collections.Generic;
using System.Linq;
using JetBrains.Annotations;

namespace Magify
{
    // ToDo: should try to optimize and avoid HashSet allocation where possible
    internal struct PurchaseLimits
    {
        [CanBeNull]
        public HashSet<string> ExcludeIfAll { get; init; }

        [CanBeNull]
        public HashSet<string> ExcludeIfAny { get; init; }

        [CanBeNull]
        public HashSet<string> IncludeIfAll { get; init; }

        [CanBeNull]
        public HashSet<string> IncludeIfAny { get; init; }
    }

    internal static class PurchaseLimitsExtensions
    {
        internal static bool IsCorresponded(this PurchaseLimits purchaseLimits, ICollection<string> purchases)
        {
            var includeAll = purchaseLimits.IncludeIfAll?.Count is null or 0 || !purchaseLimits.IncludeIfAll.Except(purchases).Any();
            var includeAny = purchaseLimits.IncludeIfAny?.Count is null or 0 || purchaseLimits.IncludeIfAny.Any(purchases.Contains);

            var excludeAll = purchaseLimits.ExcludeIfAll?.Count is null or 0 || purchaseLimits.ExcludeIfAll.Except(purchases).Any();
            var excludeAny = purchaseLimits.ExcludeIfAny?.Count is null or 0 || !purchaseLimits.ExcludeIfAny.Any(purchases.Contains);

            return includeAll && includeAny && excludeAll && excludeAny;
        }
    }
}