using System;
using System.Collections.Generic;

namespace Magify
{
    internal class LimitsModel
    {
        public TimeSpan? GlobalInterval { get; init; }
        public TimeSpan? SessionsInterval { get; init; }
        public TimeSpan? InterstitialInterval { get; init; }
        public TimeSpan? RewardInterstitialInterval { get; init; }
        public int? ImpressionsPerSession { get; init; }
        public int? InterstitialsPerSession { get; init; }
        public Dictionary<CampaignType, ImpressionLimitsModel> CampaignTypeLimits { get; init; } = new();
    }

    internal static class LimitsModelExtensions
    {
        internal static TimeSpan? GetSessionImpressionsInterval(this LimitsModel limits, CampaignType type)
        {
            return type switch
            {
                CampaignType.Interstitial => limits.InterstitialInterval,
                _ => null
            };
        }

        internal static TimeSpan? GetRelativeImpressionsInterval(this LimitsModel limits, CampaignType type)
        {
            return type switch
            {
                CampaignType.Interstitial => limits.RewardInterstitialInterval,
                _ => null
            };
        }
    }
}