﻿using System;
using System.Diagnostics;
using JetBrains.Annotations;
using Magify.Rx;
using Debug = UnityEngine.Debug;

namespace Magify
{
    internal interface IInternalConfigPrefs
    {
        IReactiveProperty<bool> IsSandbox { get; }
    }

    internal class InternalConfigPrefs : ICancelable, IInternalConfigPrefs
    {
        public static (InternalConfigPrefs, StackTrace) LiveInstance;

        [NotNull]
        private readonly BinaryStorage _storage;
        private const string KeyIsSandbox = "is_sandbox";

        [NotNull]
        public IReactiveProperty<bool> IsSandbox { get; }

        public bool IsDisposed => _storage.Disposed;

        private InternalConfigPrefs([NotNull] BinaryStorage storage)
        {
            _storage = storage;
            IsSandbox = storage.GetReactiveProperty<bool>(KeyIsSandbox);
        }

        [NotNull]
        public static InternalConfigPrefs Create([NotNull] string storagePath)
        {
            try
            {
                var storage = BinaryStorage.Construct(storagePath)
                    .AddPrimitiveTypes()
                    .Build();
                var prefs = new InternalConfigPrefs(storage);
                LiveInstance = (prefs, new StackTrace());
                return prefs;
            }
            catch (Exception)
            {
                Debug.Log("Here");
                throw;
            }
        }

        public void Dispose()
        {
            _storage.Dispose();
            LiveInstance = (null, null);
        }
    }
}