﻿using System;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    internal interface IAppStateManager
    {
        [NotNull]
        IObservable<SyncStateResult> OnRestoreStateCompleted { get; }
        [NotNull]
        IReactiveProperty<AutoRestoreStateInfo> AutoRestoreStateInfo { get; }
        [NotNull]
        IReactiveProperty<bool> IsAutoRestoreStateEnabled { get; }
        bool HasSocialAuthorizationData { get; }
        UniTask<bool> RequestSocialAuthTokenFor([NotNull] string provider, [NotNull] string token, CancellationToken cancellationToken);
        void ResetSocialAuthToken();
        UniTask<SyncStateResult> SaveState(int? weight, CancellationToken cancellationToken);
        UniTask<SyncStateResult> RestoreState(int? weight, CancellationToken cancellationToken, bool forceSync = false);
    }
}