﻿using System;

namespace Magify
{
    public class ContentHandle<T> : IDisposable
        where T : class
    {
        private readonly Action _disposeCallback;
        private bool _disposed;

        public T Value { get; private set; }
        public StorageResultCode Code { get; }

        internal ContentHandle(StorageResultCode code, T value, Action disposeCallback)
        {
            Code = code;
            Value = value;
            _disposeCallback = disposeCallback;
        }

        public void Dispose()
        {
            if (_disposed)
            {
                return;
            }
            _disposeCallback?.Invoke();
            Value = null;
            _disposed = true;
        }
    }
}