using System.Runtime.Serialization;

namespace Magify
{
    public enum SubscriptionStatus
    {
        [EnumMember(Value = "free")]
        Inactive = 0,
        [EnumMember(Value = "trial")]
        Trial = 1,
        [EnumMember(Value = "paid")]
        Paid = 2,
        [EnumMember(Value = "trial_cancelled")]
        ExpiredTrial = 3,
        [EnumMember(Value = "paid_cancelled")]
        ExpiredPaid = 4
    }

    public static class SubscriptionStateExtensions
    {
        public static bool IsActive(this SubscriptionStatus subscriptionState)
        {
            return subscriptionState == SubscriptionStatus.Trial || subscriptionState == SubscriptionStatus.Paid;
        }

        public static bool IsPaid(this SubscriptionStatus subscriptionState)
        {
            return subscriptionState == SubscriptionStatus.Paid || subscriptionState == SubscriptionStatus.ExpiredPaid;
        }
    }
}