using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;
using UnityEngine;

namespace Magify
{
    public interface ICreative
    {
        [CanBeNull]
        public IReadOnlyDictionary<string, object> Attributes { get; }
    }

    internal interface ICreativeWithId : ICreative
    {
        public string CreativeId => null;
    }

    public class CreativeBackground
    {
        [JsonIgnore]
        public Color Color { get; init; }

        public int Opacity { get; init; } = 100;
        public bool IsBlurred { get; init; }
    }

    public class NoUiCreative : ICreative
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
    }

    public class CustomCreative : ICreativeWithId
    {
        string ICreativeWithId.CreativeId => ScreenId;
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public string ScreenId { get; init; }
    }

    public class BundleCreative : ICreative
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public string Url { get; init; }
        public float ButtonCloseTimeout { get; init; }

        [CanBeNull]
        public CreativeBackground Background { get; init; }
    }

    public class ImageCreative : ICreative
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public bool IsFullScreen => Background?.Opacity >= 100f;
        public string Portrait { get; init; }
        public string Landscape { get; init; }
        public float ButtonCloseTimeout { get; init; }

        [CanBeNull]
        public CreativeBackground Background { get; init; }
    }

    public class NotificationAlertCreative : ICreative
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public string Title { get; init; }
        public string Message { get; init; }
        public string CloseButton { get; init; }
    }

    public class PlayableCreative : ICreative
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public string Url { get; init; }
        public float ButtonCloseTimeout { get; init; }

        [CanBeNull]
        public CreativeBackground Background { get; init; }
    }

    public class SystemAlertCreative : ICreative
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public string Title { get; init; }
        public string Message { get; init; }
        public string CloseButton { get; init; }
        public string ActionButton { get; init; }
    }
}