﻿using System;

namespace Magify
{
    public class MagifyFeatureNotFoundException : MagifyException
    {
        public readonly Type FeatureType;
        public readonly string FeatureName;

        public MagifyFeatureNotFoundException(Type featureType, string featureName)
            : base($"Can't find {featureType.Name} feature {featureName}")
        {
            FeatureType = featureType;
            FeatureName = featureName;
        }
    }
}