﻿using System;
using System.Collections.Generic;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    public interface IAghanimApi
    {
        [NotNull]
        IReactiveProperty<float> VerificationRetryInterval { get; }
        [NotNull]
        IObservable<(string OrderId, AghanimOrderStatus Status)> OnOrderStatusChanged { get; }

        UniTask<AghanimOrder> IssueOrder([NotNull] string productId, bool isSansbox, CancellationToken cancellationToken);
        [NotNull]
        IEnumerable<AghanimOrderInfo> IterateAllOrders();
        UniTask<IReadOnlyList<AghanimProductCounting>> LoadPurchasedProductsAsync(CancellationToken cancellationToken);

        [ContractAnnotation("=> true, productId:notnull; => false, productId:null")]
        bool TryGetProductOfOrder([NotNull] string orderId, [CanBeNull] out string productId);
        bool TryGetOrderInfo([NotNull] string orderId, out AghanimOrderInfo info);
        bool TryGetOrderWithStatus([NotNull] string orderId, out AghanimOrderStatus status);
        UniTask<AghanimOrderStatus> WaitForFinalOrderStatusAsync(string orderId, CancellationToken cancellationToken);
    }
}