﻿using JetBrains.Annotations;
using Newtonsoft.Json;
using UnityEngine.Scripting;

namespace Magify
{
    [Preserve]
    public class AghanimOrder
    {
        [JsonProperty("order_id"), NotNull, Preserve]
        public string Id { get; init; }

        [JsonProperty("checkout_url"), NotNull, Preserve]
        public string Url { get; init; }

        [JsonProperty("price"), NotNull, Preserve]
        public string Price { get; init; }

        [JsonProperty("currency"), NotNull, Preserve]
        public string Currency { get; init; }
    }

    public struct AghanimOrderInfo
    {
        [NotNull]
        public string Id { get; init; }

        public AghanimOrderStatus Status { get; init; }

        [NotNull]
        public string Price { get; init; }

        [NotNull]
        public string Currency { get; init; }

        public AghanimOrderInfo([NotNull] string id, AghanimOrderStatus status, [NotNull] string price, [NotNull] string currency)
        {
            Id = id;
            Status = status;
            Price = price;
            Currency = currency;
        }
    }
}