using System;
using Magify.Rx;
using UnityEngine;

namespace Magify
{
    internal class DisposableCounter : IDisposable
    {
        private readonly IReactiveProperty<int> _counter;
        private bool _disposed;

        public DisposableCounter(IReactiveProperty<int> counter)
        {
            _counter = counter;
            _counter.Value++;
        }

        public void Dispose()
        {
            if (_disposed) return;
            _disposed = true;
            if (_counter.Value <= 0)
            {
                Debug.LogError($"{nameof(DisposableCounter)} - unable to decrease value because it will be negative!");
                return;
            }
            _counter.Value--;
        }
    }
}