using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    /// <summary>
    /// This class allows you to pass additional arguments to <see cref="MagifyService.Initialize"/> method.
    /// </summary>
    public class MagifyServiceArgs
    {
        /// <summary>
        /// You can use this argument to mock campaigns.
        /// It will be used by <see cref="MagifyService.RequestCampaignAsync"/> with highest priority before the real campaigns from local or remote config/context. <br/>
        /// Be sure that you don't pass it in production builds. Also, you should use it only in editor mode.
        /// </summary>
        public MagifyEditorMoq EditorMoq { get; init; }

        /// <inheritdoc cref="MagifyConfig.CustomClientId"/>
        public CustomClientId CustomClientId { get; init; }

        /// <summary>
        /// You can provide you custom realization of popups provider. It will be used to show campaign creatives. <br/>
        /// Also, you can use it as popups/screens manager in your game via <see cref="MagifyService.Popups"/> (only full version of Magify).
        /// </summary>
        public IPopupsProvider PopupsProvider { get; init; }

        /// <inheritdoc cref="MagifyService.ExternalPurchaseVerificationHandler"/>
        /// <remarks>
        /// You can change it later using <b>MagifyService.ExternalPurchaseVerificationHandler</b>
        /// </remarks>
        public IPurchaseVerificationHandler PurchaseVerificationHandler { get; init; }

        /// <summary>
        /// Default logging status. You can change it later using <see cref="MagifyService.IsLoggingEnabled"/> <br/>
        /// Don't forget to set 'MAGIFY_VERBOSE_LOGGING' in 'Scripting Define Symbols' in Player Settings to see logs in the console. <br/>
        /// Look at <see cref="MagifyManager"/>.<see cref="MagifyManager.Logging"/> and <see cref="LoggingScope"/> for more precise control of logging.
        /// </summary>
        public bool IsLoggingEnabled { get; set; } = true;

        /// <summary>
        /// Default environment. You can change it later using <see cref="MagifyService.Environment"/>
        /// Don't forget to set Production environment in production builds.
        /// </summary>
        public Environment Environment { get; set; } = Environment.Staging;

        public bool IsSandbox { get; set; }

        /// <inheritdoc cref="ConfigScope"/>
        /// <remarks>
        /// <inheritdoc cref="ConfigScope" path="/remarks"/> <br/>
        /// You can change it later using <see cref="MagifyService"/>.<see cref="MagifyService.RemoteConfigScopes"/>
        /// </remarks>
        public ConfigScope? RemoteConfigScopes { get; set; }

        /// <inheritdoc cref="MagifyService.StoredAppFeaturesPreloadingEnabled"/>
        /// <summary>
        /// <inheritdoc cref="MagifyService.StoredAppFeaturesPreloadingEnabled" path="/summary"/> <br/>
        /// You can change it later using <see cref="MagifyService"/>.<see cref="MagifyService.StoredAppFeaturesPreloadingEnabled"/>
        /// </summary>
        public bool StoredAppFeaturesPreloadingEnabled { get; set; }

        /// <inheritdoc cref="MagifyConfig.SyncStateEnabled"/>
        [CanBeNull]
        public bool? SyncStateEnabled { get; init; } = false;

        /// <inheritdoc cref="MagifyConfig.IsAutoRestoreStateEnabled"/>
        public bool IsAutoRestoreStateEnabled { get; init; } = true;

        /// <inheritdoc cref="MagifyConfig.SkipClientIdFromCloudLoading"/>
        public bool SkipClientIdFromCloudLoading { get; init; } = false;

        /// <inheritdoc cref="MagifyConfig.ClientIdFromCloudLoadingTimeout"/>
        public uint ClientIdFromCloudLoadingTimeout { get; init; } = 30;

        /// <inheritdoc cref="MagifyConfig.ClientStateConfig"/>
        [NotNull]
        public ClientStateConfig ClientStateConfig { get; init; } = new();

        /// <summary>
        /// Sets the source config for editor mode.
        /// </summary>
        /// <code>
        /// RuntimePlatform.IPhonePlayer -> MagifySettings.ConfigIOS
        /// RuntimePlatform.Android and other -> MagifySettings.ConfigGP
        /// </code>
        public RuntimePlatform EditorConfigMode { get; set; } = RuntimePlatform.Android;

        /// <inheritdoc cref="MagifyConfig.IsGdprApplied"/>
        public bool? IsGdprApplied { get; set; }

        /// <inheritdoc cref="MagifyConfig.IsDeveloperMode"/>
        public bool IsDeveloperMode { get; set; }

        /// <inheritdoc cref="MagifyConfig.IsAttAuthorized"/>
        public bool? IsAttAuthorized { get; set; }

        /// <remarks>
        /// For debugging reasons. `MAGIFY_DEBUG` or `UNITY_EDITOR` define symbols are required
        /// </remarks>
        [CanBeNull]
        public string CustomAndroidId { get; init; }

        /// <remarks>
        /// For debugging reasons. `MAGIFY_DEBUG` or `UNITY_EDITOR` define symbols are required
        /// </remarks>
        [CanBeNull]
        public string CustomBuildNumber { get; init; }

        /// <remarks>
        /// For debugging reasons. `MAGIFY_DEBUG` or `UNITY_EDITOR` define symbols are required
        /// </remarks>
        [CanBeNull]
        public string CustomAppVersion { get; init; }
    }
}