using System;
using System.Threading;
using Cysharp.Threading.Tasks;
using UnityEngine;

namespace Magify
{
    internal class ReadyInterstitialCampaignHandler : InterstitialCampaignHandler
    {
        private static readonly MagifyLogger _logger = MagifyLogger.Get(MagifyService.LogScope);

        private readonly PopupsHandler _popups;

        public ReadyInterstitialCampaignHandler(AdvertiserService advertiser, PopupsHandler popups)
            : base(advertiser)
        {
            _popups = popups;
        }

        public override bool CanHandleCampaign(CampaignRequest request)
        {
            return request.Campaign is InterstitialCampaign { Screen: NoSplash or LoaderSplash or PopupSplash } && Advertiser.Mediator is { IsInterVideoReady: true };
        }

        public override async UniTask<CampaignResult> HandleCampaignAsync(CampaignRequest request, CancellationToken cancellationToken)
        {
            _logger.Log("Inter video already loaded.");
            var campaign = (InterstitialCampaign)request.Campaign;
            if (campaign.Screen is PopupSplash { IsForced: true } popupSplash)
            {
                try
                {
                    _logger.Log("Show 'Take a Break' popup before InterVideo");
                    await _popups.ShowInterPopupSplash(TimeSpan.FromSeconds(popupSplash.Time), cancellationToken);
                }
                catch (OperationCanceledException)
                {
                    _logger.Log("Inter loading was canceled");
                    return CampaignResult.Aborted;
                }
            }

            return await ShowIterVideoAd(request);
        }
    }
}