﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using UnityEditor.PackageManager;
using UnityEditor.PackageManager.Requests;

namespace Magify.DependenciesInstaller
{
    internal static class ScopedRegistryInstaller
    {
        public static async Task<Request<RegistryInfo>> Install(ScopedRegistry scopedRegistry)
        {
            var getRequest = GetRegistries();
            while (getRequest.Status == StatusCode.InProgress) await Task.Yield();
            var registryName = scopedRegistry.RegistryName;
            while (getRequest.Result.Any(registry => registry.name == registryName)) registryName += " variant";

            var addRequest = Add(registryName, scopedRegistry.URL, scopedRegistry.Scopes);
            while (addRequest.Status == StatusCode.InProgress) await Task.Yield();
            return addRequest;
        }

        public static Request<RegistryInfo> Add(string registryName, string url, string[] scopes)
        {
            const string methodName = "AddScopedRegistry";
            var type = typeof(Client);
            var info = type.GetMethod(methodName, BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Static, null, new[] { typeof(string), typeof(string), typeof(string[]) }, null);
            return (Request<RegistryInfo>)info!.Invoke(null, new object[] { registryName, url, scopes, });
        }

        public static Request<RegistryInfo[]> GetRegistries()
        {
            const string methodName = "GetRegistries";
            var type = typeof(Client);
            var info = type.GetMethod(methodName, BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Static, null, Array.Empty<Type>(), null);
            return (Request<RegistryInfo[]>)info!.Invoke(null, default);
        }

        public static async Task<IReadOnlyList<string>> GetScopes()
        {
            var request = GetRegistries();
            while (request.Status == StatusCode.InProgress) await Task.Yield();
            var scopes = new List<string>();
            foreach (var registry in request.Result)
            {
                var registryScopes = (string[])typeof(RegistryInfo).GetProperty("scopes", BindingFlags.Public | BindingFlags.NonPublic | BindingFlags.Instance)?.GetValue(registry);
                if (registryScopes != null) scopes.AddRange(registryScopes);
            }
            return scopes;
        }
    }
}