using System;
using System.IO;
using System.Net;
using System.Threading.Tasks;
using UnityEngine;

namespace Magify.DependenciesInstaller
{
    public static class PackageDownloader
    {
        public static async Task<bool> TryDownload(string url, string packageNameWithExtension)
        {
            if (string.IsNullOrWhiteSpace(url) || string.IsNullOrWhiteSpace(packageNameWithExtension)) return false;
            try
            {
                await Task.Yield();
                var webClient = new WebClient();
                var localPath = $"Packages/{packageNameWithExtension}".Replace('\\', '/');
                var globalPath = Path.GetFullPath(localPath).Replace('\\', '/');
                await webClient.DownloadFileTaskAsync(url, globalPath);
                if (File.Exists(globalPath))
                {
                    Debug.Log($"File {packageNameWithExtension} is downloaded to folder {localPath}");
                    await DependenciesInstaller.Install($"file:{packageNameWithExtension}", packageNameWithExtension);
                    return true;
                }
                Debug.LogError($"Failed to download {packageNameWithExtension} to folder {localPath}");
            }
            catch (Exception e)
            {
                Debug.LogException(e);
            }
            return false;
        }
    }
}