using NUnit.Framework;

namespace Magify.BundleCreator.Editor.Tests
{
    public class EmbeddedCreativesTests
    {
        // News feed name
        [TestCase("bonus_6c5ca676e03fb9f93eaf8217b4bc9d5b_de729dd7-c300-4543-8a98-f10f7923e9d4_3ltVN5O.png", "de729dd7-c300-4543-8a98-f10f7923e9d4.png")]
        [TestCase("external_ee389b0e3cd730210f703fa78abf128f_20014996-ea9c-49ab-bc4d-e3d1f2504eac.jpeg", "20014996-ea9c-49ab-bc4d-e3d1f2504eac.jpeg")]
        [TestCase("external_ee389b0e_20014996-ea9c-49ab-bc4d-e3d1f2504eac.png", "20014996-ea9c-49ab-bc4d-e3d1f2504eac.png")]
        [TestCase("external_ee389b0e_20014996-ea9c-49ab-bc4d-e3d1f2504eac.jpg", "20014996-ea9c-49ab-bc4d-e3d1f2504eac.jpg")]
        // Default creative name
        [TestCase("665fe6d4ccb7116334c50c30bf41d576_66c31d39-10ba-4e17-ba75-1be59ed7d24c.png", "66c31d39-10ba-4e17-ba75-1be59ed7d24c.png")]
        [TestCase("665fe6d4ccb7116334c50c30bf41d576_66c31d39-10ba-4e17-ba75-1be59ed7d24c.jpeg", "66c31d39-10ba-4e17-ba75-1be59ed7d24c.jpeg")]
        [TestCase("665fe6d4ccb7116334c50c30bf41d576_66c31d39-10ba-4e17-ba75-1be59ed7d24c.jpg", "66c31d39-10ba-4e17-ba75-1be59ed7d24c.jpg")]
        // Lto spot name
        [TestCase("default_spot_main_lto_1.6016.png", "default_spot_main_lto_1.png")]
        [TestCase("default_spot_main_lto_1.6016_8qFBbdE.png", "default_spot_main_lto_1.png")]
        [TestCase("default_spot_main_lto_1.6016_8qFBbdE.jpeg", "default_spot_main_lto_1.jpeg")]
        [TestCase("default_spot_main_lto_1.6016_8qFBbdE.jpg", "default_spot_main_lto_1.jpg")]
        public void WhenGetNameForCreative_ThenReturnCorrectName(string source, string expect)
        {
            // Act.
            var result = EmbeddedCreativesEditorTools.GetNewNameForCreative(source);

            // Assert.
            Assert.AreEqual(expect, result);
        }
    }
}