﻿#if UNITY_LOCALIZATION
using System.Globalization;
using UnityEngine.Localization.Settings;
using UnityEngine.Localization.SmartFormat;

namespace Magify
{
    public class UnityLocalizationRuntimeHelper : ILocalizationRuntimeHelper
    {
        public string GetCurrentLocale()
        {
            return LocalizationSettings.SelectedLocale.Identifier.Code;
        }

        public string PluralFormat(string localeCode, string format, params object[] args)
        {
            return Smart.Format(CultureInfo.GetCultureInfo(localeCode), format, args);
        }
    }
}
#endif