using Magify.Rx;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class EmptyDisposableTests
    {
        [Test]
        public void WhenGetAndDispose_ThenNoErrors()
        {
            // Arrange
            var disposable = EmptyDisposable.Singleton;

            // Act
            try
            {
                disposable.Dispose();
            }
            catch
            {
                Assert.Fail();
            }

            // Assert
            Assert.Pass();
        }

        [Test]
        [TestCase(2)]
        [TestCase(10)]
        [TestCase(100)]
        public void WhenGetAndDisposeMultipleTimes_ThenNoErrors(int repeats)
        {
            // Arrange
            var disposable = EmptyDisposable.Singleton;

            // Act
            try
            {
                for (var i = 0; i < repeats; i++)
                {
                    disposable.Dispose();
                }
            }
            catch
            {
                Assert.Fail();
            }

            // Assert
            Assert.Pass();
        }
    }
}