﻿using System.Collections.Generic;
using FluentAssertions;
using NUnit.Framework;

namespace Magify.Tests
{
    internal class ReplaceCampaignTypeWithStringTests
    {
        [Test]
        public void Replace_CheckAllInRight()
        {
            // Arrange
            var dic = new Dictionary<string, object>
            {
                { "ct1", CampaignType.RewardedVideo },
                { "ct2", CampaignType.Mixed },
                { "nct1", 1 },
                { "nct2", "hello" },
                { "pct2", CampaignType.Bonus.ToEnumString() },
            };

            // Act
            dic.ReplaceCampaignTypeWithString();

            // Assert
            dic["ct1"].Should().Be(CampaignType.RewardedVideo.ToEnumString());
            dic["ct2"].Should().Be(CampaignType.Mixed.ToEnumString());
            dic["nct1"].Should().Be(1);
            dic["nct2"].Should().Be("hello");
            dic["pct2"].Should().Be(CampaignType.Bonus.ToEnumString());
        }
    }
}