﻿using System;
using System.Collections.Generic;
using System.Linq;
using Magify.Model;

namespace Magify.Tests.Utils
{
    internal class CampaignTrackingUtils
    {
        private const string EventSource = "tests";

        public static IDisposable CreateCountersChangingScope<T>(Counter<T> counter, CounterKey key, int offset, params T[] ignored) where T : unmanaged, Enum
        {
            var scopes = EnumExtensions.GetValues<T>().ToArray();
            var snapshot = scopes.ToDictionary(
                scope => scope,
                scope => counter[scope, key]);
            return new CountersChangingScope<T>(counter, scopes, snapshot, key, offset, ignored);
        }

        public static void CreateAndTrackRequest<T>(string campaignName, CampaignsTracker campaignsTracker) where T : ICampaign, new()
        {
            var campaign = new T();
            typeof(T).GetProperty(nameof(ICampaign.Name))?.SetValue(campaign, campaignName);
            campaignsTracker.RegisterCampaignRequest(BuildRequest(campaign));
        }

        public static void CreateAndTrackClick<T>(string campaignName, string productId, string nestedName, CampaignsTracker campaignsTracker) where T : ICampaign, new()
        {
            var campaign = new T();
            typeof(T).GetProperty(nameof(ICampaign.Name))?.SetValue(campaign, campaignName);
            var nesteds = new[]
            {
                new NestedCampaign
                {
                    Name = nestedName,
                    ProductId = productId,
                    StoreName = PurchaseStore.Native,
                },
            };
            campaignsTracker.RegisterCampaignRequest(BuildRequest(campaign, nesteds: nesteds));
            campaignsTracker.TrackClick(campaignName, productId, PurchaseStore.Native);
        }

        public static void CreateAndTrackClick<T>(string campaignName, IReadOnlyList<NestedCampaign> nesteds, CampaignsTracker campaignsTracker) where T : ICampaign, new()
        {
            var campaign = new T();
            typeof(T).GetProperty(nameof(ICampaign.Name))?.SetValue(campaign, campaignName);
            campaignsTracker.RegisterCampaignRequest(BuildRequest(campaign, nesteds: nesteds));
            campaignsTracker.TrackClick(campaignName, nesteds.First().ProductId, PurchaseStore.Native);
        }

        public static void CreateAndTrackImpression<T>(string campaignName, CampaignsTracker campaignsTracker) where T : ICampaign, new()
        {
            var campaign = new T();
            typeof(T).GetProperty(nameof(ICampaign.Name))?.SetValue(campaign, campaignName);
            campaignsTracker.RegisterCampaignRequest(BuildRequest(campaign));
            campaignsTracker.TrackImpression(campaignName);
        }

        public static void CreateAndTrackAdsImpression<T>(string campaignName, CampaignsTracker campaignsTracker) where T : ICampaign, new()
        {
            var campaign = new T();
            typeof(T).GetProperty(nameof(ICampaign.Name))?.SetValue(campaign, campaignName);
            campaignsTracker.RegisterCampaignRequest(BuildRequest(campaign));
            campaignsTracker.TrackAdsImpression(campaignName);
        }

        public static CampaignRequest BuildRequest(
            ICampaign campaign,
            SourceType source = SourceType.Event,
            IReadOnlyList<NestedCampaign> nesteds = default,
            Dictionary<string, object> @params = default,
            bool isDefault = false,
            string eventSource = EventSource)
        {
            return new CampaignRequest
            {
                Campaign = campaign,
                Source = new CampaignSource(eventSource, source),
                IsDefaultCampaign = isDefault,
                NestedCampaigns = nesteds,
                ParsedProducts = null,
                CustomParams = @params
            };
        }
    }
}