using System;
using FluentAssertions;
using Magify.Model;
using Magify.Rx;
using NUnit.Framework;

namespace Magify.Tests
{
    internal partial class MagifyClientTests
    {
        public class AppLaunch : MagifyClientTestsPart
        {
            [Test]
            [TestCase(ClientKind.Minimal)]
            [TestCase(ClientKind.Full)]
            public void WhenMagifyClientInitialized_ThanOnlyOneAppLaunchEventSent(ClientKind kind)
            {
                // Arrange
                var appLaunchEvents = 0;
                using var client = CreateDefault(kind);
                GetAnalyticsTracker(client)
                    .OnEventSent
                    .Where(e => e is EventType.AppLaunch)
                    .Subscribe(_ => appLaunchEvents++);

                // Act
                client.InitializeSdk();

                // Assert
                appLaunchEvents.Should().Be(1);
            }

            [Test]
            [TestCase(1, ClientKind.Full)]
            [TestCase(1, ClientKind.Minimal)]
            [TestCase(2, ClientKind.Full)]
            [TestCase(2, ClientKind.Minimal)]
            [TestCase(7, ClientKind.Full)]
            [TestCase(7, ClientKind.Minimal)]
            [TestCase(30, ClientKind.Full)]
            [TestCase(30, ClientKind.Minimal)]
            public void WhenNewSessionStarted_ThanOnlyOneAppLaunchEventSent(int backgroundForegroundCycles, ClientKind kind)
            {
                // Arrange
                var appLaunchEvents = 0;
                using var client = CreateDefaultAndInit(kind);
                var platform = (PlatformDefault)GetPlatformAPI(client);
                GetAnalyticsTracker(client)
                    .OnEventSent
                    .Where(e => e is EventType.AppLaunch)
                    .Subscribe(_ => appLaunchEvents++);

                // Act
                // Simulate session change
                GetSessionCounter(client).Interval.Value = TimeSpan.Zero;
                for (var i = 0; i < backgroundForegroundCycles; i++)
                {
                    platform.GoToBackground();
                    platform.ReturnToForeground();
                }

                // Assert
                appLaunchEvents.Should().Be(backgroundForegroundCycles);
            }
        }
    }
}