using System.IO;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;

namespace Magify.Tests
{
    internal class AppStateFromTestFileProvider : IAppStateProvider
    {
        [NotNull]
        private readonly string _filePath;

        public AppStateFromTestFileProvider([NotNull] string filePath)
        {
            _filePath = filePath;
        }

        public async UniTask<string> PrepareState(CancellationToken cancellationToken)
        {
            if (File.Exists(_filePath))
            {
                var task = File.ReadAllTextAsync(_filePath, cancellationToken);
                if (task != null)
                {
                    return await task;
                }
            }
            return string.Empty;
        }

        public async UniTask HandleState([NotNull] string state, [CanBeNull] int? weight, CancellationToken cancellationToken)
        {
            var dir = Path.GetDirectoryName(_filePath)!;
            if (!Directory.Exists(dir))
            {
                Directory.CreateDirectory(dir);
            }
            var task = File.WriteAllTextAsync(_filePath, state, cancellationToken);
            if (task != null)
            {
                await task;
            }
        }
    }
}