﻿using FluentAssertions;
using NUnit.Framework;
using UnityEngine;

namespace Magify.Tests
{
    public class AppVersionProviderTests
    {
        [Test]
        public void WhenCreateAppVersionProviderAndGetAppVersion_ThenReturnUnityApplicationVersion()
        {
            //Arrange
            var appVersionProvider = new AppVersionProvider();

            //Act
            var appVersion = appVersionProvider.AppVersion;

            //Assert
            appVersion.Should()!.Be(Application.version);
        }

        [Test]
        public void WhenSetCustomAppVersion_ThenReturnTheSameVersion()
        {
            //Arrange
            var appVersionProvider = new AppVersionProvider();

            //Act
            appVersionProvider.Custom("17.3.2c.11bd_beta");
            var appVersion = appVersionProvider.AppVersion;

            //Assert
            appVersion.Should()!.Be("17.3.2c.11bd_beta");
        }
    }
}