using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Serialization;

namespace Magify
{
    internal static class JsonFacade
    {
        public static JsonSerializerSettings DefaultSettings { get; } = new()
        {
            NullValueHandling = NullValueHandling.Ignore,
            ContractResolver = new DefaultContractResolver(),
            Converters = new List<JsonConverter>
            {
                new DictionaryConverter(),
                new StringNullableEnumConverter(),
                new StringEnumConverter(),
                new ProductStoreConverter(),
            },
        };

        [NotNull]
        public static JsonSerializer DefaultSerializer { get; } = JsonSerializer.Create(DefaultSettings);

        [NotNull]
        public static string SerializeObject([NotNull] object value)
        {
            return JsonConvert.SerializeObject(value, DefaultSettings);
        }

        public static string SerializeObject(object value, JsonSerializerSettings settings)
        {
            return JsonConvert.SerializeObject(value, settings);
        }

        public static string SerializeObject(object value, Formatting formatting)
        {
            return JsonConvert.SerializeObject(value, formatting, DefaultSettings);
        }

        [CanBeNull]
        public static T DeserializeObject<T>([NotNull] string json)
        {
            return JsonConvert.DeserializeObject<T>(json, DefaultSettings);
        }

        public static bool IsNullOrEmpty(string json)
        {
            return string.IsNullOrEmpty(json) || json == "null";
        }
    }
}