﻿using System;
using System.Runtime.Serialization;
using JetBrains.Annotations;

namespace Magify
{
    public class MagifyBinaryStorageException : MagifyException
    {
        public MagifyBinaryStorageException()
        {
        }

        public MagifyBinaryStorageException([NotNull] SerializationInfo info, StreamingContext context) : base(info, context)
        {
        }

        public MagifyBinaryStorageException(string message) : base($"[{nameof(BinaryStorage)}] {message}")
        {
        }

        public MagifyBinaryStorageException(string message, Exception innerException) : base($"[{nameof(BinaryStorage)}] {message}", innerException)
        {
        }
    }
}