﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class BinaryStorageDoesntSupportTypeException : MagifyBinaryStorageException
    {
        public string StorageFileName { get; }
        public Type Type { get; }

        public BinaryStorageDoesntSupportTypeException(string storageFileName, [NotNull] Type type)
            : base($"Storage {storageFileName} doesn't support {type.FullName}. Did you forget to add it during storage creation?")
        {
            StorageFileName = storageFileName;
            Type = type;
        }
    }
}