﻿using System;
using JetBrains.Annotations;

namespace Magify
{
    public class BinaryStorageDoesntSupportCollectionException : MagifyBinaryStorageException
    {
        public string StorageFilePath { get; }
        public Type CollectionType { get; }
        public Type CollectionGenericArg { get; }

        public BinaryStorageDoesntSupportCollectionException(string storageFilePath, [NotNull] Type collectionType, Type collectionGenericArg)
            : base($"Storage {storageFilePath} doesn't support {collectionType.FullName}<{collectionGenericArg}>. " +
                   $"Did you forget to call specific {nameof(BinaryStorage.Builder)}.Support method during storage initialization?")
        {
            StorageFilePath = storageFilePath;
            CollectionType = collectionType;
            CollectionGenericArg = collectionGenericArg;
        }
    }

    public class BinaryStorageDoesntSupportSetOfException : MagifyBinaryStorageException
    {
        public Type ItemType { get; }

        public BinaryStorageDoesntSupportSetOfException([NotNull] Type itemType)
            : base($"Call {nameof(BinaryStorage.Builder.AddEntry)} for {itemType.FullName} before adding support for Set<{itemType.Name}>.")
        {
            ItemType = itemType;
        }
    }

    public class BinaryStorageDoesntSupportListOfException : MagifyBinaryStorageException
    {
        public Type ItemType { get; }

        public BinaryStorageDoesntSupportListOfException([NotNull] Type itemType)
            : base($"Call {nameof(BinaryStorage.Builder.AddEntry)} for {itemType.FullName} before adding support for List<{itemType.Name}>.")
        {
            ItemType = itemType;
        }
    }

    public class BinaryStorageDoesntSupportDictionaryOfException : MagifyBinaryStorageException
    {
        public Type KeyType { get; }
        public Type ValueType { get; }

        public BinaryStorageDoesntSupportDictionaryOfException([NotNull] Type keyType, [NotNull] Type valueType)
            : base($"Call {nameof(BinaryStorage.Builder.AddEntry)} for {keyType.FullName} and {valueType.FullName} before adding support for Dictionary<{keyType.Name}, {valueType.Name}>.")
        {
            KeyType = keyType;
            ValueType = valueType;
        }
    }
}