﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;

namespace Magify.Types
{
    internal class UnionReadOnlyCollection<T> : IReadOnlyCollection<T>, ICollection<T>
    {
        private class ReadOnlyException : Exception
        {
            public ReadOnlyException() : base($"There is no way to change {nameof(UnionReadOnlyCollection<T>)} because it is read-only")
            {
            }
        }

        private readonly IReadOnlyList<ICollection<T>> _collections;

        public int Count => _collections.Sum(c => c.Count);
        public bool IsReadOnly => true;

        public UnionReadOnlyCollection(params ICollection<T>[] collections)
        {
            _collections = collections;
        }

        public bool Contains(T item)
        {
            return _collections.Any(c => c.Contains(item));
        }

        public IEnumerator<T> GetEnumerator() => _collections.SelectMany(collection => collection).GetEnumerator();

        IEnumerator IEnumerable.GetEnumerator() => GetEnumerator();

        #region Not supported functionallity

        void ICollection<T>.Add(T item)
        {
            throw new ReadOnlyException();
        }

        public bool Add(T item)
        {
            throw new ReadOnlyException();
        }

        public void Clear()
        {
            throw new ReadOnlyException();
        }

        public void CopyTo(T[] array, int arrayIndex)
        {
            throw new ReadOnlyException();
        }

        public bool Remove(T item)
        {
            throw new ReadOnlyException();
        }

        #endregion
    }
}