﻿using System;
using System.Linq;
using System.Reflection;

namespace Magify
{
    internal static class TypeExtensions
    {
        public const BindingFlags DefaultBindingFlags = BindingFlags.Default | BindingFlags.Instance | BindingFlags.Static | BindingFlags.Public | BindingFlags.NonPublic;

        /// <summary>
        /// Resets all events with specified binding flags to null.
        /// Works only for events with backing fields (without custom add{} and remove{} methods)
        /// </summary>
        public static void ResetEvents(this Type type, object obj, BindingFlags bindingFlags = DefaultBindingFlags)
        {
            type
                .GetEvents(bindingFlags)
                .Select(e => type.GetField(e.Name, bindingFlags))
                .Where(f => f != null)
                .ForEach(f => f.SetValue(obj, null));
        }
    }
}