﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using JetBrains.Annotations;

namespace Magify
{
    internal class AbstractProductsCollection
    {
        private readonly IList _originalProductsList;

        public AbstractProductsCollection([NotNull] IList originalProductsList)
        {
            _originalProductsList = originalProductsList;
        }

        public void PullStateFrom(IReadOnlyCollection<ProductDef> target)
        {
            for (var i = _originalProductsList.Count - 1; i >= 0; i--)
            {
                var item = (ProductDef)_originalProductsList[i];
                if (target.All(p => p.Id != item.Id))
                {
                    RemoveProduct(item.Id);
                }
            }

            foreach (var product in target)
            {
                if (IndexOf(p => p.Id == product.Id) == -1)
                {
                    AddProduct(product);
                }
            }
        }

        public void AddProduct(ProductDef productDef)
        {
            _originalProductsList.Add(productDef);
        }

        public void RemoveProduct(string productId)
        {
            var index = IndexOf(p => p.Id == productId);
            _originalProductsList.RemoveAt(index);
        }

        private int IndexOf(Predicate<ProductDef> predicate)
        {
            for (var i = 0; i < _originalProductsList.Count; i++)
            {
                if (predicate((ProductDef)_originalProductsList[i]))
                {
                    return i;
                }
            }
            return -1;
        }
    }
}