#if UNITY_EDITOR || UNITY_IOS
using Newtonsoft.Json;
using UnityEngine.Scripting;
using System.Collections.Generic;
using Magify.Model;
using JetBrains.Annotations;

namespace Magify
{
    internal partial class PlatformIOS
    {
        [Preserve]
        private class GeneralPrefsMigrationData
        {
            [JsonProperty("clientId"), CanBeNull, Preserve]
            public string ClientId { get; init; }

            [JsonProperty("firstInstalledVersion"), CanBeNull, Preserve]
            public string FirstInstalledVersion { get; init; }

            [JsonProperty("firstLaunchDate"), CanBeNull, Preserve]
            public double FirstLaunchDate { get; init; }

            [JsonProperty("adjustId"), CanBeNull, Preserve]
            public string AdjustId { get; init; }

            [JsonProperty("attAuthorizationStatus"), CanBeNull, Preserve]
            public bool AttAuthorizationStatus { get; init; }

            [JsonProperty("usedFromDefaultConfigCampaignTypes"), CanBeNull, Preserve]
            public HashSet<string> UsedDefaultCampaignTypes { get; init; }

            [JsonProperty("productsTimestamps"), CanBeNull, Preserve]
            public Dictionary<string, double> ProductsTimestamps { get; init; }

            [JsonProperty("purchasedInApps"), CanBeNull, Preserve]
            public HashSet<string> PurchasedInAppProducts { get; init; }

            [JsonProperty("purchasedSubscriptionIds"), CanBeNull, Preserve]
            public HashSet<string> PurchasedSubscriptionProducts { get; init; }

            [JsonProperty("consumedProductIds"), CanBeNull, Preserve]
            public HashSet<string> UsedFreeProducts { get; init; }

            [JsonProperty("firebaseInstanceId"), CanBeNull, Preserve]
            public string FirebaseInstanceId { get; init; }

            [JsonProperty("sessionVersionAgnosticCounter"), CanBeNull, Preserve]
            public int GlobalSessionCounter { get; init; }

            [JsonProperty("sessionId"), CanBeNull, Preserve]
            public string SessionId { get; init; }

            [JsonProperty("sessionOpeningTimestamp"), CanBeNull, Preserve]
            public long SessionStarted { get; init; }

            [JsonProperty("sessionClosingTimestamp"), CanBeNull, Preserve]
            public long LastActivity { get; init; }

            [JsonProperty("mediaSource"), CanBeNull, Preserve]
            public MediaSourceMigrationData MediaSourceMigrationData { get; init; }
        }

        [Preserve]
        private class MediaSourceMigrationData
        {
            [JsonProperty("network"), Preserve]
            public string NetworkName;

            [JsonProperty("campaign"), Preserve]
            public string CampaignName;

            [JsonProperty("adGroup"), Preserve]
            public string GroupName;
        }

        [Preserve]
        private class CachedEventsMigrationData
        {
            [JsonProperty("AppLaunch"), CanBeNull, Preserve]
            public List<AppLaunchEvent> AppLaunchEvents { get; init; }

            [JsonProperty("SessionEvent"), CanBeNull, Preserve]
            public List<CustomSessionEvent> SessionEventEvents { get; init; }

            [JsonProperty("StartEndSession"), CanBeNull, Preserve]
            public List<AppBackgroundEvent> AppBackgroundEvents { get; init; }

            [JsonProperty("Transaction"), CanBeNull, Preserve]
            public List<TransactionEvent> TransactionEvents { get; init; }

            [JsonProperty("FirebaseMapping"), CanBeNull, Preserve]
            public List<FirebaseMappingEvent> FirebaseMappingEvents { get; init; }

            [JsonProperty("MailingListStatusesMapping"), CanBeNull, Preserve]
            public List<MailingStatusMappingEvent> MailingStatusMappingEvents { get; init; }

            [JsonProperty("Impression"), CanBeNull, Preserve]
            public List<CampaignImpressionEvent> ImpressionEvents { get; init; }

            [JsonProperty("ApplovinAdsImpression"), CanBeNull, Preserve]
            public List<AdsImpressionEvent> ApplovinAdsImpressionEvents { get; init; }

            [JsonProperty("LevelPlayAdsImpression"), CanBeNull, Preserve]
            public List<AdsImpressionEvent> IronSourceAdsImpressionEvents { get; init; }

            [JsonProperty("ImpressionFail"), CanBeNull, Preserve]
            public List<ImpressionFailEvent> ImpressionFailEvents { get; init; }

            [JsonProperty("TrialActivation"), CanBeNull, Preserve]
            public List<ProductPurchaseEvent> TrialActivationEvents { get; init; }

            [JsonProperty("PaidSubscriptionActivation"), CanBeNull, Preserve]
            public List<ProductPurchaseEvent> PaidSubscriptionActivationEvents { get; init; }

            [JsonProperty("inApps"), CanBeNull, Preserve]
            public List<ProductPurchaseEvent> InAppEvents { get; init; }

            [JsonProperty("Click"), CanBeNull, Preserve]
            public List<CampaignImpressionEvent> ClickEvents { get; init; }

            [JsonProperty("AdsClick"), CanBeNull, Preserve]
            public List<CampaignImpressionEvent> AdsClickEvents { get; init; }

            [JsonProperty("verifyReceiptAnalytics"), CanBeNull, Preserve]
            public List<PurchaseRecord> PurchasedRecords { get; init; }
        }

        [Preserve]
        private class LtoInfoMigrationData
        {
            [JsonProperty("isPriorityLaunch"), Preserve]
            public bool IsPriorityLaunch { get; init; }

            [JsonProperty("launchedTrigger"), CanBeNull, Preserve]
            public string LaunchedTrigger { get; init; }

            [JsonProperty("defaultSpotImage"), CanBeNull, Preserve]
            public string DefaultSpotImage { get; init; }

            [JsonProperty("campaignName"), Preserve]
            public string CampaignName { get; init; }

            [JsonProperty("spot"), Preserve]
            public string Spot { get; init; }

            [JsonProperty("startTime"), Preserve]
            public double StartTime { get; init; }

            [JsonProperty("endTime"), Preserve]
            public double EndTime { get; init; }
        }
    }
}
#endif