using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class SaveStatePayload
    {
        [JsonProperty("progress"), NotNull]
        public string Progress { get; init; }

        [JsonProperty("weight"), CanBeNull]
        public int? Weight { get; init; }

        [JsonProperty("last_sync_at"), CanBeNull]
        public long? LastSyncTime { get; init; }

        [NotNull]
        public override string ToString()
        {
            return JsonFacade.SerializeObject(this);
        }
    }
}