using System.Collections.Generic;
using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class NestedCampaign
    {
        [JsonProperty("name")]
        [CanBeNull]
        public string Name { get; set; }

        [JsonProperty("product_id")]
        [CanBeNull]
        public string ProductId { get; set; }

        [JsonProperty("product_id_creative")]
        [CanBeNull]
        public string ProductIdCreative { get; set; }

        [JsonProperty("store_name")]
        public PurchaseStore StoreName { get; set; }

        [JsonProperty("type")]
        [CanBeNull]
        public ProductType? Type { get; set; }

        [JsonProperty("product_context")]
        [CanBeNull]
        public Dictionary<string, object> ProductContext { get; set; }

        [JsonProperty("count")]
        [CanBeNull]
        public int? Count { get; set; }

        [JsonProperty("link")]
        [CanBeNull]
        public string LinkUrl { get; set; }

        [JsonProperty("creative")]
        [CanBeNull]
        public CardCreativeModel CreativeModel { get; set; }

        [JsonProperty("promoted_application")]
        [CanBeNull]
        public PromotedApplication PromotedApplication { get; set; }

        [JsonProperty("global_rv_limit")]
        [CanBeNull]
        public int? GlobalRewardLimit { get; set; }

        [JsonProperty("session_rv_limit")]
        [CanBeNull]
        public int? SessionRewardLimit { get; set; }

        [JsonProperty("daily_rv_limit")]
        [CanBeNull]
        public int? DailyRewardLimit { get; set; }

        [JsonProperty("activation_rv_limit")]
        [CanBeNull]
        public int? ActivationRewardLimit { get; set; }

        [JsonProperty("is_over_after_watching_rv")]
        [CanBeNull]
        public int? RewardOverAfterWatchLimit { get; set; }

        [JsonProperty("global_purchase")]
        [CanBeNull]
        public int? GlobalPurchaseLimit { get; set; }

        [JsonProperty("session_purchase")]
        [CanBeNull]
        public int? SessionPurchaseLimit { get; set; }

        [JsonProperty("daily_purchase")]
        [CanBeNull]
        public int? DailyPurchaseLimit { get; set; }

        [JsonProperty("activation_purchase")]
        [CanBeNull]
        public int? ActivationPurchaseLimit { get; set; }

        [JsonProperty("global_bonus")]
        [CanBeNull]
        public int? GlobalBonusLimit { get; set; }

        [JsonProperty("session_bonus")]
        [CanBeNull]
        public int? SessionBonusLimit { get; set; }

        [JsonProperty("daily_bonus")]
        [CanBeNull]
        public int? DailyBonusLimit { get; set; }

        [JsonProperty("activation_bonus")]
        [CanBeNull]
        public int? ActivationBonusLimit { get; set; }

        [JsonProperty("global_limit")]
        [CanBeNull]
        public int? GlobalOrdinaryLimit { get; set; }

        [JsonProperty("session_limit")]
        [CanBeNull]
        public int? SessionOrdinaryLimit { get; set; }

        [JsonProperty("daily_limit")]
        [CanBeNull]
        public int? DailyOrdinaryLimit { get; set; }

        [JsonProperty("activation_limit")]
        [CanBeNull]
        public int? ActivationOrdinaryLimit { get; set; }

        // Filters
        // Payment statuses
        [JsonProperty("subscription_status")]
        [CanBeNull]
        public CampaignSubscriptionStatus? SubscriptionStatus { get; set; }

        [JsonProperty("inapp_status")]
        [CanBeNull]
        public CampaignInAppStatus? InAppStatus { get; set; }

        [JsonProperty("social_authorization_status")]
        [CanBeNull]
        public CampaignAuthorizationStatus? AuthorizationStatus { get; set; }

        [JsonProperty("paying_status")]
        [CanBeNull]
        public CampaignPayingStatus? PayingStatus { get; set; }

        // Referrer ids
        [JsonProperty("include_referrer_ids")]
        [CanBeNull]
        public List<ReferrerItem> IncludeReferrerIds { get; set; }

        [JsonProperty("exclude_referrer_ids")]
        [CanBeNull]
        public List<ReferrerItem> ExcludeReferrerIds { get; set; }

        // Purchases edges
        [JsonProperty("exclude_if_all_purchased")]
        [CanBeNull]
        public List<PurchasedItem> ExcludeIfAllPurchased { get; set; }

        [JsonProperty("exclude_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> ExcludeIfAnyPurchased { get; set; }

        [JsonProperty("include_if_all_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAllPurchased { get; set; }

        [JsonProperty("include_if_any_purchased")]
        [CanBeNull]
        public List<PurchasedItem> IncludeIfAnyPurchased { get; set; }
    }
}
