using JetBrains.Annotations;
using Newtonsoft.Json;

namespace Magify.Model
{
    internal class MailingStatusMappingEvent : IAnalyticsEvent
    {
        [JsonProperty("email")]
        public string Email { get; init; }

        [JsonProperty("original_app_version")]
        public string AppVersion { get; init; }

        [JsonProperty("timestamp")]
        public double Timestamp { get; init; } = TimestampExtensions.UtcNowTimestamp;

        [JsonProperty("isBasicIntegration"), CanBeNull]
        public bool? IsBasicIntegration { get; init; }

        /// <remarks>
        /// For deserialization
        /// </remarks>
        public MailingStatusMappingEvent()
        {
        }
    }
}