﻿using System;

namespace Magify
{
    public class DisposableTuple<T> : IDisposable
        where T : IDisposable
    {
        private readonly (T item1, T item2) _tuple2;

        public DisposableTuple((T item1, T item2) tuple2)
        {
            _tuple2 = tuple2;
        }

        public void Dispose()
        {
            _tuple2.item1?.Dispose();
            _tuple2.item2?.Dispose();
        }
    }
}