﻿using JetBrains.Annotations;
using UnityEngine;

namespace Magify
{
    public static class CampaignCreativeExtensions
    {
        [CanBeNull]
        internal static CreativeBackground AsCreativeBackground(this Model.CreativeBackground model)
        {
            if (model == null) return null;
            return new CreativeBackground
            {
                Color = model.Color?.ToColor() ?? Color.gray,
                Opacity = model.Opacity ?? 100,
                IsBlurred = model.IsBlurred ?? false,
            };
        }
    }
}