using System;
using System.Collections.Generic;
using System.Threading;
using Cysharp.Threading.Tasks;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    internal interface IMagifyClient : ICancelable
    {
        internal const string CountersFolderName = "counters";
        internal const string GeneralPrefsName = "general.bin";
        internal const string LocalGeneralPrefsName = "generallocal.bin";
        internal const string OffersPrefsName = "lto.bin";
        internal const string AppStatePrefsName = "appstate.bin";
        internal const string AghanimPrefsName = "aghanim.bin";

        [NotNull]
        IAghanimApi AghanimApi { get; }
        IFeatures Features { get; }
        IReactiveProperty<bool> IsGeoIpEnabled { get; }
        IReactiveProperty<Environment> Environment { get; }
        [NotNull]
        IReactiveProperty<IPurchaseVerificationHandler> ExternalPurchaseVerificationHandler { get; }
        [NotNull]
        IReactiveProperty<float> VerificationRetryInterval { get; }
        IReactiveProperty<bool> SyncStateEnabled { get; }
        IUniTaskSource<bool> ClientIdFromCloudLoadingPromise { get; }
        IObservable<SyncStateResult> OnRestoreStateCompleted { get; }
        IReadOnlyReactiveProperty<AutoRestoreStateInfo> AutoRestoreStateInfo { get; }
        IReactiveProperty<bool> IsAutoRestoreStateEnabled { get; }
        bool HasSocialAuthorizationData { get; }
        bool SkipClientIdFromCloudLoading { get; set; }
        uint ClientIdFromCloudLoadingSecondsTimeout { get; set; }
        IReactiveProperty<SubscriptionStatus> SubscriptionStatus { get; }
        IReactiveProperty<InAppStatus> InAppStatus { get; }
        IReactiveProperty<AuthorizationStatus> AuthorizationStatus { get; }
        IReactiveProperty<string> AdjustId { get; }
        IReactiveProperty<string> FirebaseInstanceId { get; }
        IReactiveProperty<string> ReferrerId { get; }
        IReactiveProperty<bool> IsGdprGranted { get; }
        IReadOnlyReactiveProperty<string> GpsAdId { get; }
        IReadOnlyReactiveProperty<bool?> AttAuthorizationStatus { get; }
        [NotNull]
        IReadOnlyReactiveProperty<long> LastSuccessfulSyncProgressUnixTimeSeconds { get; }
        bool ShouldSendLastSyncProgressTime { get; set; }
        bool IsTablet { get; }
        bool IsPortrait { get; }
        ContextSyncTime LastContextSyncTime { get; }
        IReactiveProperty<TimeSpan> SessionsInterval { get; }
        string ClientId { get; }
        IReadOnlyReactiveProperty<string> CommonClientId { get; }
        bool CustomClientIdWasSet { get; }
        LimitsModel Limits { get; }
        IReadOnlyReactiveProperty<int> SessionNumber { get; }
        IReadOnlyList<InAppProduct> InAppProducts { get; }
        IReadOnlyList<SubscriptionProduct> SubscriptionProducts { get; }
        IReadOnlyReactiveProperty<IReadOnlyList<string>> Segmentations { get; }
        IReadOnlyReactiveProperty<IReadOnlyList<AssignedAbTest>> AssignedAbTests { get; }
        [NotNull]
        public IStoredAppFeaturesCollection StoredAppFeaturesProvider { get; }
        PlatformAPI Platform { get; }
        string FirstInstalledVersion { get; }
        DateTime FirstLaunchDate { get; }
        [NotNull]
        public IReactiveProperty<ConfigScope> RemoteContextScopes { get; }
        [NotNull]
        public string AppVersion { get; set; }

        event Action<ConfigKind> OnConfigParsed;
        event Action<ConfigKind> OnConfigParsedOnMainThread;
        event Action OnConfigLoaded;
        event Action OnConfigSyncRequested;
        event Action<LtoInfo> OnOfferAdded;
        event Action<LtoInfo> OnOfferUpdated;
        event Action<LtoInfo> OnOfferRemoved;
        event Action<LtoInfo> OnOfferFinished;
        event Action OnPurchasedProductsChanged;
        event Action OnUserDidTakeScreenshot;
        event Action OnApplicationEnterForeground;
        event Action OnApplicationEnterBackground;
        void InitializeSdk();
        UniTask AwaitInitialConfigParsing(CancellationToken cancellationToken);
        void Setup();
        void Sync();
        ICampaign CampaignFor(string eventName, IReadOnlyDictionary<string, object> customParams = null, bool silent = false);
        bool IsCampaignAvailable(string campaignName, string eventName, Dictionary<string, object> customParams = null);
        [NotNull]
        IReadOnlyCollection<LtoInfo> GetActiveLtoOffers();
        void CompleteOffer(string campaignName);
        CampaignImpression GetCampaignImpression(string campaignName);
        IList<ContentItem> GetContentList([NotNull] string group, [NotNull] string key, ICollection<string> tags = null);
        ContentItem GetEarliestContent(string group, string key);
        ContentItem GetLatestContent(string group, string key);
        bool HasProcessedPurchase(string productId);
        bool SubscribeCampaignUpdates(ICampaign campaign, Action onUpdate);
        void UnsubscribeCampaignUpdates(string campaignName, Action onUpdate);
        void ClearSubscriptions(string campaignName);
        void TweakAnalyticsConfig(int eventsGroupSize, int syncTimeInterval);
        void ResetAnalyticsConfig();
        UniTask<string> ForceReissueAuthToken(CancellationToken cancellationToken);
        void RefreshGpsAdId();
        void TweakFirstLaunchDate(DateTime date);
        void TweakUserLocale([NotNull] string languageTag);
        void SetAttStatus(bool authorized);
        void SetGameLevel(int level);
        void SetGameMaxLevel(int maxLevel);
        void SetGameMode([CanBeNull] string mode);
        void SetUserEmail(string email);
        UniTask<bool> RequestSocialAuthTokenFor([NotNull] string provider, [NotNull] string token, CancellationToken cancellationToken);
        void ResetSocialAuthToken();
        UniTask<SyncStateResult> SaveState(int? weight, CancellationToken cancellationToken);
        UniTask<SyncStateResult> RestoreState(int? weight, CancellationToken cancellationToken);
        void SetMediaSource(string networkName, string campaignName, string adGroup);
        void SetupConversionTracker(string revenuePerCountryPath, string revenueLevelsPath, string defaultCurrencyRatesPath, string subscriptionMultipliersPath);
        void TrackCustomEvent(string eventName, Dictionary<string, object> customParams = null);
        void TrackImpression(string campaignName);
        void TrackParentCampaignImpression(string campaignName);
        void TrackProductsImpression(string campaignName, IReadOnlyList<string> productIds);
        void TrackImpressionFailFor(string campaignName, string reason);
        void TrackAdsImpression(string campaignName, IAdsImpression impression);
        void TrackClickFor(string campaignName);
        void TrackProductClickFor(string campaignName, string productId, PurchaseStore? store);
        void TrackAdsClickFor(string campaignName);
        void TrackAdsProductClickFor(string campaignName, string productId);
        void TrackSubscriptionActivation(bool isTrial, string productId, string price, string currency, string transactionId, string purchaseToken, string originalTransactionId, string receipt, bool needValidation, PurchaseStore store);
        void TrackExternalSubscriptionActivation(bool isTrial, string productId, string price, string currency, string transactionId, string purchaseToken, string originalTransactionId, string receipt, bool needValidation, PurchaseStore store);
        void TrackInAppFor(string productId, string price, string currency, string transactionId, string purchaseToken, string originalTransactionId, string receipt, bool needValidation, PurchaseStore store);
        void TrackExternalInAppFor(string productId, string price, string currency, string transactionId, string purchaseToken, string originalTransactionId, string receipt, bool needValidation, PurchaseStore store);
        void TrackTrustedPurchase([NotNull] TrustedPurchaseRecord record, bool? isSubscription, bool? isExternal);
        void TrackRestoredInAppFor(string productId);
        void TrackRestoredSubscription(string productId);
        void TrackRewardGranted(string productId);
        void TrackFreeBonusGranted(string productId);
        void TrackOrdinaryProductUsed(string productId);
        void TrackIncomeTransaction(string source, List<BonusInfo> bonuses, ProductInfo product = null);
        void TrackExpenseTransaction(List<BonusInfo> bonuses);
        void TrackCorrectionTransaction(List<BonusInfo> bonuses);
        CampaignRequest GetLastCampaignRequest(string campaignName);
        CampaignRequest GetLastCampaignRequest(CampaignType campaignType);
        bool IsApplicationInstalled([CanBeNull] string identifier);
        void ResetContext(bool cancelIfLoading);
        void Reset(bool clearNativeStorage = true, bool clearCloudStorage = true);
        void ClearNativeStorage();
    }
}