﻿using System.Linq;
using Magify.Model;

namespace Magify.Features
{
    internal static class FeatureConfigExtensions
    {
        public static ReferrerLimits GetReferrerLimits(this FeatureTrigger trigger)
        {
            return new ReferrerLimits
            {
                IncludeIds = trigger.IncludeReferrerIds?.Select(item => item.Id).ToHashSet(),
                ExcludeIds = trigger.ExcludeReferrerIds?.Select(item => item.Id).ToHashSet()
            };
        }

        public static PurchaseLimits GetPurchaseLimits(this FeatureTrigger trigger)
        {
            return new PurchaseLimits
            {
                ExcludeIfAll = trigger.ExcludeIfAllPurchased?.Select(item => item.Product).ToHashSet(),
                ExcludeIfAny = trigger.ExcludeIfAnyPurchased?.Select(item => item.Product).ToHashSet(),
                IncludeIfAll = trigger.IncludeIfAllPurchased?.Select(item => item.Product).ToHashSet(),
                IncludeIfAny = trigger.IncludeIfAnyPurchased?.Select(item => item.Product).ToHashSet()
            };
        }
    }
}