﻿using System.Collections.Generic;
using JetBrains.Annotations;

namespace Magify
{
    internal static class DefaultMagifyEncoders
    {
        [NotNull, ItemNotNull]
        private static IReadOnlyDictionary<EncodingMode, IMagifyEncoder> Encoders { get; } = new Dictionary<EncodingMode, IMagifyEncoder>
        {
            { EncodingMode.ToJsonToZipToBase64, new ToJsonToZipToBase64MagifyEncoder() },
            { EncodingMode.ToJsonToBase64, new ToJsonToBase64MagifyEncoder() },
        };

        [NotNull]
        public static IMagifyEncoder Get(EncodingMode encodingMode)
        {
            return Encoders[encodingMode];
        }
    }
}