using JetBrains.Annotations;

namespace Magify
{
    internal interface IMagifyWorker
    {
        bool BreakExecution => false;
    }

    internal interface IMagifyWorker<T> : IMagifyWorker
        where T : IMagifyWorkerJob
    {
        void DoJob([NotNull] T job);
    }

    internal interface IMagifyWorker<T, TR> : IMagifyWorker
        where T : IMagifyWorkerJob
    {
        [CanBeNull]
        TR DoJob([NotNull] T job);
    }

    internal interface IMagifyWorkerJob
    {
    }
}