using System;
using System.Runtime.Serialization;

namespace Magify
{
    /// <summary>
    /// Allows you to control scopes of config that will be loaded with the next requests to the server.
    /// </summary>
    /// <remarks>
    /// Use <see cref="ConfigScope.None"/> if you want to load all the content of config. <br/>
    /// Remember, that <see cref="ConfigScope.Segmentations"/> and <see cref="ConfigScope.AbTests"/> won't be included in request if <see cref="ConfigScope.None"/> was set. You have to request them manually. <br/>
    /// Keep in mind that in the basic Magify integration only <see cref="ConfigScope.AppFeatures"/>, <see cref="ConfigScope.StoredAppFeatures"/> and <see cref="ConfigScope.Content"/> scoops make sense,
    /// requesting the others only wastes extra internet traffic and takes extra time. <br/>
    /// You should realize, that <see cref="ConfigScope.ProductIds"/> content is using by Magify SDK internally (for external purchases, subscription status and others),
    /// so you should be careful and request this scope at least once.
    /// </remarks>
    [Flags]
    public enum ConfigScope : long
    {
        None              = 0L,
        [EnumMember(Value = "limits")]
        Limits            = 1L << 0,
        [EnumMember(Value = "product_ids")]
        ProductIds        = 1L << 1,
        // [EnumMember(Value = "prediction")] // going to be added in future
        // Prediction     = 1L << 2,
        [EnumMember(Value = "content")]
        Content           = 1L << 3,
        [EnumMember(Value = "campaigns")]
        Campaigns         = 1L << 4,
        // [EnumMember(Value = "deleted_content")] // going to be added in future
        // DeletedContent = 1L << 5,
        [EnumMember(Value = "app_features")]
        AppFeatures       = 1L << 6,
        [EnumMember(Value = "segmentations")]
        Segmentations     = 1L << 7,
        [EnumMember(Value = "ab_tests")]
        AbTests           = 1L << 8,
        [EnumMember(Value = "stored_app_features")]
        StoredAppFeatures = 1L << 9,
    }
}