﻿using System;
using System.Collections.Generic;
using JetBrains.Annotations;
using Magify.Rx;

namespace Magify
{
    public interface IStoredAppFeaturesCollection : IEnumerable<StoredAppFeature>
    {
        [NotNull]
        public IObservable<Unit> OnChanged { get; }

        bool Contains([NotNull] string featureName);
        bool TryGet([NotNull] string featureName, out StoredAppFeature feature);
    }
}