using System.Collections.Generic;

namespace Magify
{
    public interface ISplashScreen
    {
        IReadOnlyDictionary<string, object> Attributes { get; }
    }

    public class NoSplash : ISplashScreen
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public double Timeout { get; init; }
    }

    public class LoaderSplash : ISplashScreen
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public double MinTime { get; init; }
        public double MaxTime { get; init; }
    }

    public class PopupSplash : ISplashScreen
    {
        public IReadOnlyDictionary<string, object> Attributes { get; init; }
        public double Time { get; init; }
        public double Timeout { get; init; }
        public double MaxTime { get; init; }
        public bool IsForced { get; init; }
    }
}