﻿using System;
using JetBrains.Annotations;

namespace Magify.Rx
{
    // Optimize for .Select().Where()
    internal class SelectWhereObservable<T, TR> : OperatorObservableBase<TR>
    {
        [NotNull]
        private readonly IObservable<T> _source;
        [NotNull]
        private readonly Func<T, TR> _selector;
        [NotNull]
        private readonly Func<TR, bool> _predicate;

        public SelectWhereObservable([NotNull] IObservable<T> source, [NotNull] Func<T, TR> selector, [NotNull] Func<TR, bool> predicate)
        {
            _source = source;
            _selector = selector;
            _predicate = predicate;
        }

        protected override IDisposable SubscribeCore([NotNull] IObserver<TR> observer, [NotNull] IDisposable cancel)
        {
            return _source.Subscribe(new SelectWhere(this, observer, cancel));
        }

        private class SelectWhere : OperatorObserverBase<T, TR>
        {
            [NotNull]
            private readonly SelectWhereObservable<T, TR> _parent;

            public SelectWhere([NotNull] SelectWhereObservable<T, TR> parent, [NotNull] IObserver<TR> observer, [NotNull] IDisposable cancel) : base(observer, cancel)
            {
                _parent = parent;
            }

            public override void OnNext(T value)
            {
                TR v;
                try
                {
                    v = _parent._selector(value);
                }
                catch (Exception ex)
                {
                    try { Observer.OnError(ex); } finally { Dispose(); }
                    return;
                }

                bool isPassed;
                try
                {
                    isPassed = _parent._predicate(v);
                }
                catch (Exception ex)
                {
                    try { Observer.OnError(ex); } finally { Dispose(); }
                    return;
                }

                if (isPassed)
                {
                    Observer.OnNext(v);
                }
            }

            public override void OnError([NotNull] Exception error)
            {
                try { Observer.OnError(error); } finally { Dispose(); }
            }

            public override void OnCompleted()
            {
                try { Observer.OnCompleted(); } finally { Dispose(); }
            }
        }
    }
}